// Sistema de Tabs para Escuela de Obstetricia
document.addEventListener('DOMContentLoaded', function() {
    // Tabs principales (Escuela / Resena Historica)
    const tabButtons = document.querySelectorAll('.tabs-buttons .tab-button');
    const tabContents = document.querySelectorAll('.tabs-content .tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');

            // Remover clase active de todos los botones y contenidos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));

            // Agregar clase active al boton clickeado y su contenido correspondiente
            this.classList.add('active');
            document.getElementById(targetTab).classList.add('active');
        });
    });

    // Tabs de Carrera Profesional (Menu lateral)
    const carreraMenuItems = document.querySelectorAll('.carrera-menu-item');
    const carreraTabContents = document.querySelectorAll('.carrera-tab-content');

    carreraMenuItems.forEach(item => {
        item.addEventListener('click', function() {
            const targetCarreraTab = this.getAttribute('data-carrera-tab');

            // Remover clase active de todos los items del menu y contenidos
            carreraMenuItems.forEach(menuItem => menuItem.classList.remove('active'));
            carreraTabContents.forEach(content => content.classList.remove('active'));

            // Agregar clase active al item clickeado y su contenido correspondiente
            this.classList.add('active');
            document.getElementById(targetCarreraTab).classList.add('active');
        });
    });
});
